package game;

import java.awt.Color;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;


public class DoorSprite {
	
	private int destinationPlayerSpawnX;
	private int destinationPlayerSpawnY;
	private LevelData levelData;
	private String destinationRoomName;
	
	private int xPos;
	private int yPos;
	
	private CustomImageDataII image;
	
	private IntRect collisionRect;
	
	public DoorSprite(BufferedReader in, LevelData theLevel, PonyPanel ponyPanel, boolean fromFiles) throws IOException {
		
		levelData = theLevel;
		xPos = Integer.MIN_VALUE;
		yPos = Integer.MIN_VALUE;
		
		String inputter;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.contains("#"))
				continue;
			else if(inputter.contains("graphic:")) {
				
				String array[] = inputter.split("\\*");
				
				Color transparentColor = CustomImageData.translateFileInStringToColor(array[1]);
				
				if(fromFiles) {
					
					image = new CustomImageDataII(new File(array[0].substring(8).trim()), transparentColor, ponyPanel);
					
				} else {
					
					String imageFile = "/images/" + array[0].substring(8).trim() + ".GIF";
	//				URL url = DoorSprite.class.getResource(imageFile);
	//				if(url != null) {
	//					ImageIcon ii = new ImageIcon(url);
	//					image = new CustomImageData(ii.getImage(), ii.getIconWidth(), ii.getIconHeight(), transparentColor, ponyPanel);
	//				}
					image = new CustomImageDataII(imageFile, transparentColor, ponyPanel);
					
				}
			} else if(inputter.contains("x:")) {
				xPos = Integer.parseInt(inputter.substring(2).trim());
//				System.out.println("and the x-pos is:  <<" + inputter + ">>");
			} else if(inputter.contains("y:")) {
				yPos = Integer.parseInt(inputter.substring(2).trim());
//				System.out.println("and the y-pos is:  <<" + inputter + ">>");
			} else if(inputter.contains("destinationRoom:")) {
				destinationRoomName = inputter.substring(16).trim();
			} else if(inputter.contains("destinationX:")) {
				destinationPlayerSpawnX = Integer.parseInt(inputter.substring(13).trim());
			} else if(inputter.contains("destinationY:")) {
				destinationPlayerSpawnY = Integer.parseInt(inputter.substring(13).trim());
			} else if(inputter.contains("/door")) {
				break;
			}
			
		}
		
		if(image == null || xPos == Integer.MIN_VALUE || yPos == Integer.MIN_VALUE) {
//			System.err.println("error occurred:  the door's data was not populated properly.");
			return;
		}
		
		
		collisionRect = new IntRect(xPos - image.getDesiredWidth()/2, yPos - image.getDesiredHeight()/2, image.getDesiredWidth(), image.getDesiredHeight());
		
		
	}
	
	
	public void draw(Graphics g, PlayerSprite player, int panelWidth, int panelHeight) {
		
		if(image != null)
			image.drawObject(g, panelWidth/2 + (xPos - player.getxPos()) , panelHeight/2 + (yPos - player.getyPos()));
		
	}
	
	public void primeImage(Graphics g, int panelWidth, int panelHeight) {
//		if(image != null)
//			image.primeImage(g, panelWidth, panelHeight);
	}
	
	public int getXPos() {
		return xPos;
	}
	
	public int getYPos() {
		return yPos;
	}
	
	public IntRect getCollisionRect() {
		return collisionRect;
	}
	
	
	public LevelData getLevelData() {
		return levelData;
	}
	
	public RoomData getDestinationRoom() {
		return levelData.getRoom(destinationRoomName);
	}


	public int getDestinationPlayerSpawnX() {
		return destinationPlayerSpawnX;
	}


	public int getDestinationPlayerSpawnY() {
		return destinationPlayerSpawnY;
	}
	
	
	

	public static void retrieveFileLengths(BufferedReader in, LevelData theLevel, PonyPanel ponyPanel, boolean fromFiles, HashMap<String, Long> fileLengths) throws IOException {
		
//		levelData = theLevel;
//		xPos = Integer.MIN_VALUE;
//		yPos = Integer.MIN_VALUE;
		
		String inputter;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.contains("#"))
				continue;
			else if(inputter.contains("graphic:")) {
				
//				System.out.println("<><>DELME  inputter is: <<" + inputter + ">>");
				
				String array[] = inputter.substring(8).split("\\*");
				
//				Color transparentColor = CustomImageData.translateFileInStringToColor(array[1]);
				FileInputStream fis = new FileInputStream(new File(array[0]));
				
				long lengthOfFile = 0L;
				
				while(fis.read() != -1)
					lengthOfFile++;
				
				fis.close();
				
				fileLengths.put(array[0], lengthOfFile);
//				if(fromFiles) {
//					
//					image = new CustomImageDataII(new File(array[0].substring(8).trim()), transparentColor, ponyPanel);
//					
//				} else {
//					
//					String imageFile = "/images/" + array[0].substring(8).trim() + ".GIF";
//	//				URL url = DoorSprite.class.getResource(imageFile);
//	//				if(url != null) {
//	//					ImageIcon ii = new ImageIcon(url);
//	//					image = new CustomImageData(ii.getImage(), ii.getIconWidth(), ii.getIconHeight(), transparentColor, ponyPanel);
//	//				}
//					image = new CustomImageDataII(imageFile, transparentColor, ponyPanel);
//					
//				}
			} else if(inputter.contains("x:")) {
//				xPos = Integer.parseInt(inputter.substring(2).trim());
//				System.out.println("and the x-pos is:  <<" + inputter + ">>");
			} else if(inputter.contains("y:")) {
//				yPos = Integer.parseInt(inputter.substring(2).trim());
//				System.out.println("and the y-pos is:  <<" + inputter + ">>");
			} else if(inputter.contains("destinationRoom:")) {
//				destinationRoomName = inputter.substring(16).trim();
			} else if(inputter.contains("destinationX:")) {
//				destinationPlayerSpawnX = Integer.parseInt(inputter.substring(13).trim());
			} else if(inputter.contains("destinationY:")) {
//				destinationPlayerSpawnY = Integer.parseInt(inputter.substring(13).trim());
			} else if(inputter.contains("/door")) {
				break;
			}
			
		}
		
//		if(image == null || xPos == Integer.MIN_VALUE || yPos == Integer.MIN_VALUE) {
//			System.err.println("error occurred:  the door's data was not populated properly.");
//			return;
//		}
//		
//		
//		collisionRect = new IntRect(xPos - image.getDesiredWidth()/2, yPos - image.getDesiredHeight()/2, image.getDesiredWidth(), image.getDesiredHeight());
		
		
	}
	
	
}
